/***************************************************************************
 *   Copyright (C) 2000 by Torsten Henschel                                *
 *   thenschel@henschelsoft.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _MAKE_POPUP_H_
#define _MAKE_POPUP_H_

#include <kcombobox.h>
#include <kdialog.h>
#include <kpushbutton.h>

#include <qmultilineedit.h>

class Make_Popup : public KDialog {
    Q_OBJECT

    public:
        Make_Popup(QWidget *, const char *, QString);
        ~Make_Popup();

    public slots:
        void sendPopup();
        void changeGroupBox(const QString &);

    private:
        void readGroupList();
        void readHostList(QString);
        QString getHostName();

        KComboBox *cb_Group;
        KComboBox *cb_Host;
        QMultiLineEdit *mle_Text;
};

#endif // _MAKE_POPUP_H_
