/***************************************************************************
 *   Copyright (C) 2000 by Torsten Henschel                                *
 *   thenschel@henschelsoft.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _KPOPUP_H_
#define _KPOPUP_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kaction.h>
#include <kuniqueapplication.h>
#include <kmainwindow.h>
#include <kstatusbar.h>
#include <ksystemtray.h>
#include <ktoolbar.h>

#include <qlabel.h>
#include <qmap.h>
#include <qtextedit.h>
#include <qtimer.h>

class KPopup : public KMainWindow {
    Q_OBJECT

    public:
            KPopup(QWidget *parent = 0, const char *name = 0);
            ~KPopup();
            void setStatusText(QString);

    protected:
            void hideEvent(QHideEvent *); // hide event

    private slots:
            void answerPopup();
            void commandCallback(int);
            void deletePopup();
            void exitKPopup();
            void helpKPopup();
            void newPopup();
            void nextPopup();
            void popupFileTimerDone();
            void previousPopup();
            void statusBarTimerDone();

    private:
            void checkMap();
            void initTimer();
            void initToolbar();
            void initStatusbar();
            void showPopup();
            void signalNewMessage(QString, QString, QString);

            KAction *actDel;
            KAction *actNext;
            KAction *actPrev;
            KAction *actReply;
            KStatusBar *statusbar;
            KToolBar *toolbar;
            KSystemTray *tray;
            QLabel *lbl_SenderValue;
            QLabel *lbl_DateTimeValue;
            QMap<int, QString> senderMap;
            QMap<int, QString> popupTextMap;
            QMap<int, QString> timeMap;
            QTextEdit *tv_Text;
            QTimer *statusBarTimer;
            QTimer *popupFileTimer;
            int actual;
};

#endif // _KPOPUP_H_
