/***************************************************************************
 *   Copyright (C) 2000 by Torsten Henschel                                *
 *   thenschel@henschelsoft.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "kpopup.h"
#include "misc.h"

#include <stdio.h>
#include <stdlib.h>

#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>


static const char description[] = I18N_NOOP("WinPopup-Client for KDE");

static const char version[] = "0.9.6pre1";

static KCmdLineOptions options[] = {
//    { "+[URL]", I18N_NOOP( "Document to open." ), 0 },
    KCmdLineLastOption
};

/*
 * main
 */
int main(int argc, char **argv) {
    KAboutData about("kpopup", I18N_NOOP("KPopup"), version, description,
                     KAboutData::License_GPL, "(C) 2000 Torsten Henschel", 0, 0, "thenschel@henschelsoft.de");
    about.addAuthor( "Torsten Henschel", 0, "thenschel@henschelsoft.de" );
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions(options);
    KUniqueApplication::addCmdLineOptions();

    // check if KPopup is already started
    if (! KUniqueApplication::start()) {
       printf("KPopup is already running!\n");
       exit(0);
    }

    KUniqueApplication app;

    if (app.isRestored())
    {
#ifdef DEBUG
        printf("KPopup will be restored by session manager\n");
#endif
        RESTORE(KPopup);
    }
    else
    {
#ifdef DEBUG
        printf("KPopup not started by session manager\n");
#endif
        // no session.. just start up normally
        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

        /// @todo do something with the command line args here

        KPopup *w = new KPopup();
        w -> setCaption("KPopup");
        app.setMainWidget(w);
        w->show();

        args->clear();
    }

    // mainWin has WDestructiveClose flag by default, so it will delete itself.
    return app.exec();
}
