/***************************************************************************
 misc.cpp - tools

 copyright : (C) 2000 by Torsten Henschel
 email     : thenschel@henschelsoft.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <malloc.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>

#include <misc.h>

/*
 * method set signal
 */
void signalSetup() {
    struct sigaction sa;

    // signal od new message
    SETSIG(SIGUSR1, signalMessage, 0);
}


/*
 * method is call by a new message
 */
void signalMessage(int sig) {

    sig = sig;
#ifdef DEBUG
    fprintf(stderr, "found signal (%i)\n", sig);
#endif
    w -> signalNewMessage();
}


/*
 * copy received message in a new format
 */
void fileCopy(const char *fileName, const char *sender) {
    char *popupText = NULL;
    char command[50];
    FILE *file;
    int i = 0;

#ifdef DEBUG
    fprintf(stdout, "filename: %s\n", fileName);
    fprintf(stdout, "sender: %s\n", sender);
#endif

    if ((file = fopen(fileName, "r")) != 0) {
        while (!feof(file)) {
            if (popupText == NULL) {
                popupText = (char *) malloc (sizeof(char));
            } else {
                popupText = (char *) realloc (popupText, sizeof(char) * i + 1);
            }
            popupText[i] = fgetc(file);
            i++;
        }
        fclose(file);

        if (popupText == NULL) {
            popupText = (char *) malloc (sizeof(char));
        } else {
            popupText = (char *) realloc (popupText, sizeof(char) * i + 1);
        }
        popupText[i - 1] = 0;
#ifdef DEBUG
        fprintf(stdout, "popuptext: %s", popupText);
#endif
#ifndef DEBUG
        sprintf(command, "rm -f %s", fileName);
        system(command);
#endif
    } else {
        fprintf(stderr, "fileerror!\n");
        return;
    }

    if ((file = fopen(TMPPOPUPFILE, "w")) != 0) {
        fprintf(file, "%s\n%s", sender, popupText);
        fclose(file);
    }
}


/*
 * send signal for a new message
 */
void sendSignalForNewMessage() {
    char command[50];

    sprintf(command, "killall -USR1 kpopup");
    system(command);
}


/*
 * read sender of messagefile
 */
char *readSender() {
    char *sender = NULL;
    char zeichen;
    FILE *file;
    int i = 0;

    if ((file = fopen(TMPPOPUPFILE, "r")) != 0) {
        while (!feof(file)) {
            zeichen = fgetc(file);
            if (zeichen != '\n') {
                if (sender == NULL) {
                    sender = (char *) malloc (sizeof(char));
                } else {
                    sender = (char *) realloc (sender, sizeof(char) * i + 1);
                }
                sender[i] = zeichen;
                i++;
            }
            else break;
        }
        fclose(file);
        if (sender == NULL) {
            sender = (char *) malloc (sizeof(char));
        } else {
            sender = (char *) realloc (sender, sizeof(char) * i + 1);
        }
        sender[i] = 0;
    } else {
        fprintf(stderr, "fileerror!\n");
    }
    return(sender);
}


/*
 * read message from messagefile
 */
char *readPopupText() {
    char *popupText = NULL;
    char zeichen;
    FILE *file;
    int i = 0;
    bool senderFertig = false;

    if ((file = fopen(TMPPOPUPFILE, "r")) != 0) {
        while (!feof(file)) {
            zeichen = fgetc(file);
            if ((zeichen == '\n') && (!senderFertig)) {
                senderFertig = true;
                continue;
            }
            if (senderFertig) {
                if (popupText == NULL) {
                    popupText = (char *) malloc (sizeof(char));
                } else {
                    popupText = (char *) realloc (popupText, sizeof(char) * i + 1);
                }
                popupText[i] = zeichen;
                i++;
            }
        }
        fclose(file);
        if (popupText == NULL) {
            popupText = (char *) malloc (sizeof(char));
        } else {
            popupText = (char *) realloc (popupText, sizeof(char) * i + 1);
        }
        popupText[i - 1] = 0;
    }
    else printf("Fileerror!\n");


#ifndef DEBUG
        char command[50];
        sprintf(command, "echo empty > %s", TMPPOPUPFILE);
        system(command);
#endif


    return(popupText);
}
