/***************************************************************************
 kpopup.h - create mainwindow

 copyright : (C) 2000 by Torsten Henschel
 email     : thenschel@henschelsoft.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPOPUP_H
#define KPOPUP_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kaction.h>
#include <kapplication.h>
#include <kmainwindow.h>
#include <kstatusbar.h>
#include <ksystemtray.h>
#include <ktoolbar.h>

#include <qdatetime.h>
#include <qmap.h>
#include <qtextview.h>

class KPopup : public KMainWindow {
    Q_OBJECT

    public:
            KPopup(QWidget *parent = 0, const char *name = 0);
            ~KPopup();
            void setStatusText(QString);
            void signalNewMessage();

    protected:
            void hideEvent(QHideEvent *); // hide event

    private slots:
            void answerPopup();
            void commandCallback(int);
            void deletePopup();
            void exitKPopup();
            void helpKPopup();
            void newPopup();
            void nextPopup();
            void previousPopup();
            void timerDone();

    private:
            void checkMap();
            void init();
            void initToolbar();
            void initStatusbar();
            void showPopup();

            KAction *actDel;
            KAction *actNext;
            KAction *actPrev;
            KAction *actReply;
            KStatusBar *statusbar;
            KToolBar *toolbar;
            KSystemTray *tray;
            QLabel *lbl_SenderValue;
            QLabel *lbl_DateTimeValue;
            QDate *currentDate;
            QMap<int, QString> senderMap;
            QMap<int, QString> popupTextMap;
            QMap<int, QString> timeMap;
            QTextView *tv_Text;
            QTime *currentTime;
            QTimer *timer;
            int actual;
};

#endif
