/***************************************************************************
                          make_popup.cpp  -  description
                          ------------------------------
    copyright            : (C) 2000 by Torsten Henschel
    email                : thenschel@henschelsoft.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <ctype.h>
#include <malloc.h>
#include <stdio.h>
#include <unistd.h>

#include <klocale.h>
#include <kmessagebox.h>

#include <qfile.h>
#include <qlayout.h>

#include <make_popup.h>
#include <misc.h>

/*
 * contructor of Make_Popup
 */
Make_Popup::Make_Popup(QWidget *parent, const char *name) : KDialog(parent, name, TRUE) {
    hostname = (char *) malloc (50 * (sizeof(char)));
    readHostName();

    QGridLayout *layout = new QGridLayout(this);

    lbl_Receiver = new QLabel(i18n("To:"), this);
    lbl_Receiver -> setMinimumWidth(50);
    layout -> addWidget(lbl_Receiver, 1, 1);

    cb_Receiver = new QComboBox(TRUE, this);
    cb_Receiver -> setMinimumWidth(250);
    layout -> addWidget(cb_Receiver, 1, 3);

    lbl_Text = new QLabel(i18n("Text:"), this);
    layout -> addWidget(lbl_Text, 3, 1);

    mle_Text = new QMultiLineEdit(this);
    mle_Text -> setMinimumHeight(180);
    mle_Text -> setMinimumWidth(350);
    layout -> addMultiCellWidget(mle_Text, 5, 5, 1, 3);    
                                                                                                            
    btn_Ok = new QPushButton(i18n("Ok"), this);
    layout -> addWidget(btn_Ok, 7, 1);
    connect(btn_Ok, SIGNAL(clicked()), SLOT(sendPopup()));

    btn_Cancel = new QPushButton(i18n("Cancel"), this );
    layout -> addWidget(btn_Cancel, 7, 3);
    connect(btn_Cancel, SIGNAL(clicked()), SLOT(reject()));

    layout -> addColSpacing(0, 10);
    layout -> addColSpacing(2, 5);
    layout -> addColSpacing(4, 10);

    layout -> addRowSpacing(0, 10);
    layout -> addRowSpacing(2, 5);    
    layout -> addRowSpacing(6, 5);    
    layout -> addRowSpacing(8, 10);    
}


/*
 * destructor of Make_Popup
 */
Make_Popup::~Make_Popup() {
    free(hostname);
}


/*
 * method sendPopup
 */
void Make_Popup::sendPopup() {
    FILE *sendprocess;
    int linecount = 0;

    QString commandLine;
    commandLine.append(SMBPATH);
    commandLine.append("/smbclient -M ");
    commandLine.append(cb_Receiver -> currentText());
    commandLine.append(" -N -U ");
    commandLine.append(hostname);
    commandLine.append(" > /dev/null");
    //printf("%s", (const char *)commandLine);

    if ((sendprocess = popen((const char *)commandLine, "w")) != 0) {
        while (linecount < mle_Text -> numLines()) {
            fprintf(sendprocess, "%s\n", (const char *)mle_Text -> textLine(linecount));
            linecount++;
        }
        if (pclose(sendprocess) == 0) {
            KMessageBox::information(this, i18n("Popup sent!"), i18n("Success"));
            reject();
        } else {
            KMessageBox::sorry(this, i18n("Popup not sent!"), i18n("Error"));
        }
    }

}


/*
 * method readHostName
 */
void Make_Popup::readHostName() {

    gethostname(hostname, 50);
    for(int i = 0; i < 50; i++) {
        if(hostname[i] == '.') {
            hostname[i] = '\x0';
            break;
        } else {
            hostname[i] = toupper(hostname[i]);
        }
    }
}


/*
 * method readBrowseList
 */
void Make_Popup::readBrowseList() {
    QFile *hostfile = new QFile("/tmp/kpopup.hostlist");
    char *line = (char *) malloc (201 * (sizeof(char)));
    char *host = (char *) malloc (22 * (sizeof(char)));
    int flag1 = 0, flag2 = 0;

    if (hostfile -> open(IO_ReadOnly)) {
        while (!(hostfile -> atEnd())) {
            hostfile -> readLine(line, 200);
            if ((strlen(line) == 1) && (flag1 == 1)) {
                flag2 = 1;
            }
            if ((flag1 == 1) && (flag2 == 0)) {
                if ((strlen(line) > 22) && (line[0] == '\t') && (strncmp(line, "	---------", 10) > 0)) {
                    line[0] = ' ';
                    line[22] = 0;
                    for (int i = 23; i >= 1; i--) {
                        host[i - 1] = 0;
                        if (line[i] == 32) {
                            host[i - 1] = 0;
                        } else {
                            host[i - 1] = line[i];
                        }
                    }
                    cb_Receiver -> insertItem(host, -1);
                }
            }
            if ((strncmp(line, "	Server               Comment", 24)) == 0) {
                flag1 = 1;
            }
        }
        free(line);
        free(host);
        hostfile -> close();
    }
}
