/***************************************************************************
                          main.cpp  -  description
                             -------------------
    copyright            : (C) 2000 by Torsten Henschel
    email                : thenschel@henschelsoft.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>

#include "kpopup.h"
#include "misc.h"

static const char *description = I18N_NOOP("WinPopup-Client for KDE");
KPopup *w;

/*
 * main methoad
 */
int main(int argc, char *argv[]) {
    char *fileName, *sender;

    // save old rigth
    uid_t e_uid = geteuid(); // efectiv right

    // reduce right
    seteuid(getuid());

    // abtesten, ob neue Nachricht kommt, oder normaler Programmstart
    if (argc == 3) {
        //neue Nachricht
        fileName = (char *)malloc(((strlen(argv[1]) + 1) * (sizeof(char))));
        sprintf(fileName, argv[1]);
        fileName[strlen(argv[1])] = 0;

        sender = (char *)malloc(((strlen(argv[2]) + 1) * (sizeof(char))));
        sprintf(sender, argv[2]);
        sender[strlen(argv[2])] = 0;

        fileCopy(fileName, sender);

        // Recht fr Signal senden erhhen
        seteuid(e_uid);
        setuid(e_uid);
        sendSignalForNewMessage();
        exit(0);
    }
    
    // init KApplication
    KApplication kApp (argc, argv, "kpopup");

    KAboutData aboutData("kpopup", "KPopup", VERSION, description, KAboutData::License_GPL,
                         "(c) 2000, Torsten Henschel");
    aboutData.addAuthor("Torsten Henschel", 0, "thenschel@henschelsoft.de");
    KCmdLineArgs::init(argc, argv, &aboutData);
        
    // check if session manager starts kpopup
    if (kApp.isRestored()) {
        printf("kpopup will be restored by session manager\n");
        RESTORE(KPopup);
    } else {
        printf("kpopup not started by session manager\n");
        w = new KPopup();
        w -> setCaption("KPopup");
        kApp.setMainWidget(w);
        w -> show();
    }

    // set signal handler
    signalSetup();
    
    return kApp.exec();
}
