/***************************************************************************
                          main.cpp  -  description
                             -------------------
    copyright            : (C) 2000 by Torsten Henschel
    email                : thenschel@henschelsoft.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>

#include "kpopup.h"
#include "misc.h"

static const char *description = I18N_NOOP("WinPopup-Client for KDE");
Kpopup *w;

/*static KCmdLineOptions options[] =
{
  { 0, 0, 0 }
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};*/


/*
 * main methoad
 */
int main(int argc, char *argv[]) {
    char *fileName, *sender;

    // Rechte sichern
    uid_t e_uid = geteuid(); // effektives Recht

    // Recht beschrnken
    seteuid(getuid());

    // abtesten, ob neue Nachricht kommt, oder normaler Programmstart
    if(argc == 3) {
        //neue Nachricht
        fileName = (char *)malloc(((strlen(argv[1]) + 1) * (sizeof(char))));
        sprintf(fileName, argv[1]);
        fileName[strlen(argv[1])] = 0;

        sender = (char *)malloc(((strlen(argv[2]) + 1) * (sizeof(char))));
        sprintf(sender, argv[2]);
        sender[strlen(argv[2])] = 0;

        fileCopy(fileName, sender);

        // Recht fr Signal senden erhhen
        seteuid(e_uid);
        setuid(e_uid);
        sendSignalForNewMessage();
        exit(0);
    }

    signalSetup();

    KAboutData aboutData("kpopup", "KPopup", VERSION, description, KAboutData::License_GPL,
                         "(c) 2000, Torsten Henschel");
    aboutData.addAuthor("Torsten Henschel", 0, "thenschel@henschelsoft.de");
    KCmdLineArgs::init(argc, argv, &aboutData);
//  KCmdLineArgs::addCmdLineOptions(options); // Add our own options.

    KApplication a;

    w = new Kpopup();
    w -> setGeometry(100, 100, 400, 400);
    w -> setCaption("KPopup");
    a.setMainWidget(w);
    w -> show();
    return a.exec();
}
