/***************************************************************************
                          kpopup.h  -  description
                             -------------------
    copyright            : (C) 2000 by Torsten Henschel
    email                : thenschel@henschelsoft.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPOPUP_H
#define KPOPUP_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <kmainwindow.h>
#include <kstatusbar.h>
#include <ktoolbar.h>

#include <qdatetime.h>
#include <qmap.h>
#include <qtextview.h>

class KSystemTray;

class Kpopup : public KMainWindow {
    Q_OBJECT

    public:
            Kpopup();
            ~Kpopup();
            void answerPopup();
            void newPopup();
            void setStatusText(const char *);
            void signalNewMessage();

    private slots:
            void commandCallback(int);
            void timerDone();

    private:
            void checkMap();
            void deletePopup();
            void dock(); // Dock to system tray
            void init();
            void initToolbar();
            void initStatusbar();
            void showPopup();

            KStatusBar *statusbar;
            KToolBar *toolbar;
            KSystemTray *tray;
            //bool dockable;
            QLabel *lbl_Sender;
            QLabel *lbl_SenderValue;
            QLabel *lbl_DateTime;
            QLabel *lbl_DateTimeValue;
            QDate *currentDate;
            QMap<int, QString> senderMap;
            QMap<int, QString> popupTextMap;
            QMap<int, QString> timeMap;
            QTextView *tv_Text;
            QTime *currentTime;
            QTimer *timer;
            int actual;
};

#endif
