/***************************************************************************
                          make_popup.cpp  -  description
                          ------------------------------
    begin                : Sun Feb 20 2000
    copyright            : (C) 2000 by Torsten Henschel
    email                : henschel@fh-brandenburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <ctype.h>
#include <malloc.h>
#include <stdlib.h>
#include <unistd.h>

#include <qdialog.h>
#include <qfile.h>
#include <qlineedit.h>
#include <qmessagebox.h>
#include <qmultilinedit.h>
#include <qpushbutton.h>

#include "make_popup.h"
#include "misc.h"

make_Popup::make_Popup(QWidget *parent, const char *name) : QDialog(parent, name, TRUE)
{
 B_Ok = new QPushButton("Ok", this);
 B_Ok -> setGeometry(25, 190, 60, 25);
 connect(B_Ok, SIGNAL(clicked()), SLOT(SendPopup()));

 B_Cancel = new QPushButton("Cancel", this );
 B_Cancel -> setGeometry(195, 190, 60,25);
 connect(B_Cancel, SIGNAL(clicked()), SLOT(reject()));

 L_User = new QLabel("From:", this);
 L_User -> setGeometry(20, 9, 30, 20);

 LE_User = new QLineEdit(this, "read-write combo");
 LE_User -> setGeometry(55, 8, 205, 22);
 ReadHostName();
 LE_User -> setMaxLength(25);

 L_Receiver = new QLabel("To:", this);
 L_Receiver -> setGeometry(20, 34, 30, 20);

 CB_Receiver = new QComboBox(TRUE, this, "read-write combo");
 CB_Receiver -> setGeometry(55, 34, 205, 26);

 L_Text = new QLabel("Text:", this);
 L_Text -> setGeometry(20, 61, 98, 20);

 MLE_Text = new QMultiLineEdit(this);
 MLE_Text -> setGeometry(20, 85, 240, 100);

 setMinimumSize(280, 220);
 setMaximumSize(280, 220);
}


void make_Popup::SendPopup()
{
 FILE *Datei;
 char *befehlszeile;
 int count=0;

 befehlszeile = (char *)malloc(182 * (sizeof(char)));
 Datei = fopen("/tmp/new.kpopup", "w+");

 while(count < MLE_Text -> numLines())
  {
   fprintf(Datei,"%s\n", MLE_Text -> textLine(count));
   count++;
  }
 fclose(Datei);
 sprintf(befehlszeile, "cat /tmp/new.kpopup | %s/smbclient -M %s -N -U %s", SMBPATH , CB_Receiver -> currentText(), LE_User -> text());
 if(system(befehlszeile) == 0)
   {
//    SaveConfigHosts(CB_Receiver -> currentText());
    QMessageBox *Super;
    Super = new QMessageBox();
    Super -> information(this, "Success", "Popup sent!");
    reject();
   }
  else
   {
    QMessageBox *Fehler;
    Fehler = new QMessageBox();
    Fehler -> information(this, "Error", "Popup not sent!");
   }
 system("rm -f /tmp/new.kpopup");
 free(befehlszeile);
}


void make_Popup::ReadBrowseList()
{
 QFile *hostfile;
 char *line;
 char *host;
 int flag1 = 0, flag2 = 0;

 line = (char *) malloc (201 * (sizeof(char)));
 host = (char *) malloc (22 * (sizeof(char)));
 hostfile = new QFile("/tmp/hostlist.kpopup");

 if(hostfile -> open(IO_ReadOnly))
   {
    while(!(hostfile -> atEnd()))
     {
      hostfile -> readLine(line, 200);
      if((strlen(line) == 1) && (flag1 == 1)) flag2 = 1;

      if((flag1 == 1) && (flag2 == 0))
        {
         if((strlen(line) > 22) && (line[0] == '\t') && (strncmp(line, "	---------", 10) > 0))
           {
            line[0] = ' ';
            line[22] = 0;
            for(int i = 23; i >= 1; i--)
             {
              host[i - 1] = 0;
              if(line[i] == 32) host[i - 1] = 0;
               else host[i - 1] = line[i];
             }
            CB_Receiver -> insertItem(host, -1);
           }
        }
      if((strncmp(line, "	Server               Comment", 24)) == 0) flag1 = 1;
     }
    free(line);
    free(host);
    hostfile -> close();
   }
}

/*
void make_Popup::ReadConfigHosts()
{
 config = kapp -> getConfig();
 config -> setGroup("HOSTS");
 fprintf(stderr, "%s\n", (const char*)config -> readEntry("RecentHost0"));
 CB_Receiver -> insertItem(config -> readEntry("RecentHost0"));
 CB_Receiver -> insertItem(config -> readEntry("RecentHost1"));
 CB_Receiver -> insertItem(config -> readEntry("RecentHost2"));
 CB_Receiver -> insertItem(config -> readEntry("RecentHost3"));
 CB_Receiver -> insertItem(config -> readEntry("RecentHost4"));
 CB_Receiver -> insertItem(config -> readEntry("RecentHost5"));
 CB_Receiver -> insertItem(config -> readEntry("RecentHost6"));
 CB_Receiver -> insertItem(config -> readEntry("RecentHost7"));
 CB_Receiver -> insertItem(config -> readEntry("RecentHost8"));
 CB_Receiver -> insertItem(config -> readEntry("RecentHost9"));
} */


void make_Popup::ReadHostName()
{
 char *host;
 host = (char *) malloc (30 * (sizeof(char)));

 gethostname(host, 30);
 for(int i = 0; i <= 29; i++) host[i] = toupper(host[i]);
 LE_User -> setText(host);

 free(host);
}


/*void make_Popup::SaveConfigHosts(const char *host)
{
 int found, i;
 char zus1[20];
 char zus2[20];

 config = kapp -> getConfig();
 config -> setGroup("HOSTS");

 found = 10;
 for(i = 0; i <= 9; i++)
  {
   sprintf(zus1, "RecentHost%i", i);
   if(strcmp((const char*)config -> readEntry(zus1), host) == 0)
     {
      found = i;
      break;
     }
  }

 if(found == 10)
   {
    found = 9;
   }

 for(i = found; i > 0; i--)
   {
    sprintf(zus1, "RecentHost%i", i);
    sprintf(zus2, "RecentHost%i", i - 1);
    config -> writeEntry(zus1, (const char*)config -> readEntry(zus2));
   }
 config -> writeEntry("RecentHost0", host);

 config -> sync();
} */